<?php

if(!defined('ABSPATH')) { die('You are not allowed to call this page directly.'); }

use EasyAffiliate\Controllers\AppCtrl;
use EasyAffiliate\Lib\CtrlFactory;
use EasyAffiliate\Lib\Jobs;

require_once ESAF_PATH . '/vendor-prefixed/autoload.php';

spl_autoload_register(function ($class) {
  $prefix = 'EasyAffiliate\\';
  $base_dir = __DIR__ . '/app/';
  $len = strlen($prefix);

  if(strncmp($prefix, $class, $len) !== 0) {
    // the class doesn't use the namespace prefix, move to the next registered autoloader
    return;
  }

  $relative_class = substr($class, $len);
  $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

  if(file_exists($file)) {
    require $file;
  }
});

add_action('activated_plugin', function ($plugin) {
  if($plugin == ESAF_PLUGIN_SLUG) {
    AppCtrl::activate();
  }
});

add_action('plugins_loaded', function () {
  // Deactivate Affiliate Royale if active
  if(defined('WAFP_PLUGIN_SLUG')) {
    if(!function_exists('deactivate_plugins')) {
      require_once ABSPATH . '/wp-admin/includes/plugin.php';
    }

    deactivate_plugins(WAFP_PLUGIN_SLUG);
  }

  CtrlFactory::all();

  AppCtrl::setup_menus();

  // Start Job Processor / Scheduler
  new Jobs();
});
