<?php

namespace EasyAffiliate\Lib;

use EasyAffiliate\Models\Options;
use EasyAffiliate\Controllers;
use EasyAffiliate\GroundLevel\Mothership\AbstractPluginConnection;

class MothershipPluginConnector extends AbstractPluginConnection
{

  /**
   * Constructor.
   */
  public function __construct()
  {
    $this->pluginId     = 'easyaffiliate';
    $this->pluginPrefix = 'ESAF_';
  }

  /**
   * Gets the license activation status option.
   *
   * @return boolean The license activation status.
   */
  public function getLicenseActivationStatus(): bool
  {
    return Controllers\UpdateCtrl::is_activated();
  }

  /**
   * Updates the license activation status option.
   *
   * @param boolean $status The status to update.
   */
  public function updateLicenseActivationStatus(bool $status): void
  {
    update_option('esaf_activated', $status);
  }

  /**
   * Gets the license key option.
   *
   * @return string The license key.
   */
  public function getLicenseKey(): string
  {
    $options = Options::fetch();
    return $options->mothership_license;
  }

  /**
   * Updates the license key option.
   *
   * @param string $licenseKey The license key to update.
   */
  public function updateLicenseKey(string $licenseKey): void
  {
    $this->plp_update->set_mothership_license($licenseKey);
  }

  /**
   * Gets the domain option.
   *
   * @return string The domain.
   */
  public function getDomain(): string
  {
    return Utils::site_domain();
  }
}
