<?php
/**
 * WPGens RAF Events
 * @author    WPGens
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPGENS_RAF_Customers_History {

	public function get_customers($days){
        $from_date = date('Y-m-d', strtotime('today - '.$days.' days'));
        $to_date = date('Y-m-d', strtotime('today + 1 day'));

        $args = array(
            'date_created' => strtotime($from_date).'...'.strtotime($to_date),
            'meta_key'      => '_raf_id',
            'meta_compare'  => 'EXISTS',
            'status' => array_keys( wc_get_order_statuses() ),
            'limit' => 9999, // might need to move this to pagination with custom query
            // 'paged' => $page,
            // 'paginate' => true
        );

        $orders = wc_get_orders($args);

        $grouped_orders = array();
        $total_amount = 0;

        foreach ($orders as $order) {
            $raf_id = $order->get_meta('_wpgens_raf_id');
            $raf_meta = $order->get_meta('_wpgens_raf_meta');

            $total_amount += $order->get_total();

            if (!empty($raf_id)) {
                
                if (!isset($grouped_orders[$raf_id])) {
                    $grouped_orders[$raf_id] = array();
                }
                $grouped_orders[$raf_id]['raf_code'] = $raf_id;

                if(isset($raf_meta['increase_referrals']) && $raf_meta['increase_referrals']) {
                    if(isset($grouped_orders[$raf_id]['total_amount'])) {
                        $grouped_orders[$raf_id]['num_of_orders'] += 1;
                        $grouped_orders[$raf_id]['total_amount'] += $order->get_total();
                    } else {
                        $grouped_orders[$raf_id]['num_of_orders'] = 1;
                        $grouped_orders[$raf_id]['total_amount'] = $order->get_total();
                    }
                }

                // Get user information by the meta key and value
                $user_query_args = array(
                    'meta_key' => 'gens_referral_id',
                    'meta_value' => $raf_id,
                );

                $user_query = new WP_User_Query($user_query_args);
                $users = $user_query->get_results();

                if (!empty($users)) {
                    $user = reset($users);
                    $grouped_orders[$raf_id]['user_id'] = $user->ID;
                    $grouped_orders[$raf_id]['user_email'] = $user->user_email;
                    $grouped_orders[$raf_id]['user_name'] = $user->first_name ? $user->first_name.' '.$user->last_name : '-';
                    $grouped_orders[$raf_id]['user_link'] = get_edit_user_link($user->ID);
                } else {
                    $grouped_orders[$raf_id]['user_email'] = $raf_id;
                }
            }
        }

        // Format with currency
        foreach ($grouped_orders as $key => $order) {
            $grouped_orders[$key]['total_amount'] = wc_price($order['total_amount']);
        }

        return array( 'data' => array_values($grouped_orders), 'total' => array( 'amount' => wc_price($total_amount), 'advocates' => count($grouped_orders), 'orders' => count($orders)) );
	}

}
