<?php
/**
 * Refer a Friend Product Share HTML
 *
 * Available variables: $rafLink (Referral link), $title (twitter title option), $twitter_via(twitter via option)
 *
 * @see     http://wpgens.helpscoutdocs.com/article/34-how-to-edit-template-files-and-keep-them-after-plugin-update
 * @version 2.3.11
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
if (filter_var($rafLink, FILTER_VALIDATE_URL) === FALSE) {
    $rafLink = "#";
}

?>
<div class="gens-referral_share">
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__fb"><i class="gens_raf_icn-facebook"></i> <?php _e("Share via Facebook","gens-raf"); ?></a>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__tw" data-via="<?php echo $twitter_via; ?>" data-title="<?php echo $title; ?>" >
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"/>
        </svg>
        <?php _e("Share via Twitter","gens-raf"); ?>
    </a>
    <?php if($whatsapp) { ?>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__wade" data-title="<?php echo $title. ' '.$rafLink; ?>"><i class="gens_raf_icn-whatsapp"></i> <?php _e("Share via WhatsApp","gens-raf"); ?></a>
    <?php } if($linkedin) { ?>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__ln"><i class="gens_raf_icn-linkedin"></i> <?php _e("Share via Linkedin","gens-raf"); ?></a>
    <?php } if($pinterest) { ?>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__pin"><i class="gens_raf_icn-pinterest"></i> <?php _e("Share via Pinterest","gens-raf"); ?></a>
    <?php } ?>
    <?php if($viber) { ?>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__viber" data-title="<?php echo $title. ' '.$rafLink; ?>"><i class="gens_raf_icn-paper-plane-1"></i> <?php _e("Share via Viber","gens-raf"); ?></a>
    <?php } ?>
    <a href="<?php echo $rafLink; ?>" class="gens-referral_share__wa" data-title="<?php echo $title; ?>"><i class="gens_raf_icn-whatsapp"></i> <?php _e("Share via WhatsApp","gens-raf"); ?></a>
</div>
<?php if(!$email_hide) { ?>
<div class="gens-referral_share__email">
    <span class="gens-referral_share__email__title"><?php _e( 'or share via email','gens-raf'); ?></span>
    <form id="gens-referral_share__email" action="" type="post" novalidate>
        <div class="gens-referral_share__email__inputs">
            <input type="email" placeholder="<?php _e( 'Enter email','gens-raf'); ?>">
            <input type="text" placeholder="<?php _e( 'Enter name','gens-raf'); ?>">
        </div>
        <a href="#" id="js--gens-email-clone">+</a>
        <a href="#" id="js--gens-email-remove">-</a>
        <input type="submit" value="<?php _e( 'Send Emails','gens-raf'); ?>">
    </form>
</div>
<?php } ?>